//
//  Software for MSP430 based e-meters.
//
//  THIS PROGRAM IS PROVIDED "AS IS". TI MAKES NO WARRANTIES OR
//  REPRESENTATIONS, EITHER EXPRESS, IMPLIED OR STATUTORY,
//  INCLUDING ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
//  FOR A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY OR
//  COMPLETENESS OF RESPONSES, RESULTS AND LACK OF NEGLIGENCE.
//  TI DISCLAIMS ANY WARRANTY OF TITLE, QUIET ENJOYMENT, QUIET
//  POSSESSION, AND NON-INFRINGEMENT OF ANY THIRD PARTY
//  INTELLECTUAL PROPERTY RIGHTS WITH REGARD TO THE PROGRAM OR
//  YOUR USE OF THE PROGRAM.
//
//  IN NO EVENT SHALL TI BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
//  CONSEQUENTIAL OR INDIRECT DAMAGES, HOWEVER CAUSED, ON ANY
//  THEORY OF LIABILITY AND WHETHER OR NOT TI HAS BEEN ADVISED
//  OF THE POSSIBILITY OF SUCH DAMAGES, ARISING IN ANY WAY OUT
//  OF THIS AGREEMENT, THE PROGRAM, OR YOUR USE OF THE PROGRAM.
//  EXCLUDED DAMAGES INCLUDE, BUT ARE NOT LIMITED TO, COST OF
//  REMOVAL OR REINSTALLATION, COMPUTER TIME, LABOR COSTS, LOSS
//  OF GOODWILL, LOSS OF PROFITS, LOSS OF SAVINGS, OR LOSS OF
//  USE OR INTERRUPTION OF BUSINESS. IN NO EVENT WILL TI'S
//  AGGREGATE LIABILITY UNDER THIS AGREEMENT OR ARISING OUT OF
//  YOUR USE OF THE PROGRAM EXCEED FIVE HUNDRED DOLLARS
//  (U.S.$500).
//
//  Unless otherwise stated, the Program written and copyrighted
//  by Texas Instruments is distributed as "freeware".  You may,
//  only under TI's copyright in the Program, use and modify the
//  Program without any charge or restriction.  You may
//  distribute to third parties, provided that you transfer a
//  copy of this license to the third party and the third party
//  agrees to these terms by its first use of the Program. You
//  must reproduce the copyright notice and any other legend of
//  ownership on each copy or partial copy, of the Program.
//
//  You acknowledge and agree that the Program contains
//  copyrighted material, trade secrets and other TI proprietary
//  information and is protected by copyright laws,
//  international copyright treaties, and trade secret laws, as
//  well as other intellectual property laws.  To protect TI's
//  rights in the Program, you agree not to decompile, reverse
//  engineer, disassemble or otherwise translate any object code
//  versions of the Program to a human-readable form.  You agree
//  that in no event will you alter, remove or destroy any
//  copyright notice included in the Program.  TI reserves all
//  rights not specifically granted under this license. Except
//  as specifically provided herein, nothing in this agreement
//  shall be construed as conferring by implication, estoppel,
//  or otherwise, upon you, any license or other right under any
//  TI patents, copyrights or trade secrets.
//
//  You may not use the Program in non-TI devices.
//
//******************************************************************************
#ifndef _EMETER_H
#define _EMETER_H


#include <msp430x471x7.h>

// The following has to be defined using the Project->Properties Window
/*#undef SELF_CALIBRATE_AP
#undef MEASURE_V_PHASE_2_PHASE
#undef REACT_POWER_BY_HILBERT_TXFM
#undef DLMS_ENABLE*/

#ifdef DLMS_ENABLE
#include <stdint.h>
#include "isr_compat.h"
#include "iec62056_46_link.h"
#include "iec62056_46_user.h"
#include "uart_comms.h"
#include <inttypes.h>

#include "cosem.h"
#include "obis.h"
#include "msgs.h"
#include "packing.h"
#include "config.h"
#endif


//#define FFT
//#define RTC_CALENDAR


#include <stdint.h>
#include "Emeter_Var.h"
//#include "Emeter_Display.h"
//#include "Emeter_Calib.h"
//#include "Emeter_Interrupts.h"

#ifdef RTC_CALENDAR
	#include "Emeter_RTC.h"
	#include "Emeter_Soft_I2C.h"
#endif

//#include "Emeter_Tamper.h"
//#include "Emeter_EEPROM.h"
//#include "Emeter_Init.h"
//
#include "LC_glass.h"

#include "math.h"
#include <stdio.h>
#include <string.h>



//#define RTC_CALENDAR

//#include "Emeter_MD.h"


//#define DEMO_MODE

#define TX_ENABLE	P7OUT |= BIT2;
#define RX_ENABLE	P7OUT &= ~BIT2;


//#define Watchdog_toggle() (P2OUT ^= BIT7)
#define Modbus_rx_led_on()(P9OUT &= ~BIT2)
#define Modbus_rx_led_off()(P9OUT |= BIT2)
#define Modbus_tx_led_on()(P9OUT &= ~BIT3)
#define Modbus_tx_led_off()(P9OUT |= BIT3)

#define Manualscroll_led_on()(P9OUT &= ~BIT5)
#define Manualscroll_led_off()(P9OUT |= BIT5)

void Sys_Clock_Init(void);
void Init_GPIO(void);
void Init_Variable(void);
void Init_UART(void);
void Init_Basic_Timer(void);
void Init_SPI(void);
//void Init_LC_glass(void);

 void Modbus_Communication(void);
 void Measurement_Calculation(void);

void AnalogFrontEnd_init(void);
void LCD_clean(void);
void start_message(void);
void Clear_Acc_Data(void);

//#ifdef RTC_CALENDAR
//	void Init_RTC(void);
//#endif

#define YES 0xff
#define NO  0x00

#define HIGH 0xAA
#define LOW  0x55

#define SD16CCTL_VOLTAGE_1  SD16CCTL0
#define SD16INCTL_VOLTAGE_1 SD16INCTL0
#define SD16PRE_VOLTAGE_1   SD16PRE0
#define SD16MEM_VOLTAGE_1   SD16MEM0

#define SD16CCTL_VOLTAGE_2  SD16CCTL1
#define SD16INCTL_VOLTAGE_2 SD16INCTL1
#define SD16PRE_VOLTAGE_2   SD16PRE1
#define SD16MEM_VOLTAGE_2   SD16MEM1

#define SD16CCTL_VOLTAGE_3  SD16CCTL2
#define SD16INCTL_VOLTAGE_3 SD16INCTL2
#define SD16PRE_VOLTAGE_3   SD16PRE2
#define SD16MEM_VOLTAGE_3   SD16MEM2

#define SD16CCTL_CURRENT_1  SD16CCTL3
#define SD16INCTL_CURRENT_1 SD16INCTL3
#define SD16PRE_CURRENT_1   SD16PRE3
#define SD16MEM_CURRENT_1   SD16MEM3

#define SD16CCTL_CURRENT_2  SD16CCTL4
#define SD16INCTL_CURRENT_2 SD16INCTL4
#define SD16PRE_CURRENT_2   SD16PRE4
#define SD16MEM_CURRENT_2   SD16MEM4

#define SD16CCTL_CURRENT_3  SD16CCTL5
#define SD16INCTL_CURRENT_3 SD16INCTL5
#define SD16PRE_CURRENT_3   SD16PRE5
#define SD16MEM_CURRENT_3   SD16MEM5
            
#define SD16CCTL_NEUTRAL    SD16CCTL6
#define SD16INCTL_NEUTRAL   SD16INCTL6
#define SD16PRE_NEUTRAL     SD16PRE6
#define SD16MEM_NEUTRAL     SD16MEM6
#define SD16INCH_CURRENT    SD16INCH_0

#define CURRENT_PHASE_GAIN                          SD16GAIN_1
#define CURRENT_PHASE_GAIN_1                        SD16GAIN_4
/*! The gain setting for the second current channel channel of the SD16,
    for devices using the SD16 sigma-delta ADC.
    This must be set to suit the shunt or CT in use. Typical values for a
    shunt are GAIN_16 (x16 gain) or GAIN_32 (x32 gain). Typical values for a
    CT are GAIN_1 (x1 gain) or GAIN_2 (x2 gain). */
#define CURRENT_NEUTRAL_GAIN                        SD16GAIN_1

/*! The gain setting for the voltage channel of the SD16, for devices using the
    SD16 sigma-delta ADC. This is usually GAIN_1 (i.e. x1 gain). */
#define VOLTAGE_GAIN                                SD16GAIN_1
#define VOLTAGE_GAIN_110                            SD16GAIN_2
#define VOLTAGE_GAIN_64                             SD16GAIN_4

// These are Tamper Detection Threshholds
#define VRMS_TAMPER_LIMIT 500
#define IRMS_TAMPER_LIMIT 250
#define RESIDUE_LIMIT     100
#define I_NEUT_TAMPER_LIMIT 250





#ifdef SELF_CALIBRATE_AP          

 
	#define CALIBRATE_IDLE            0x50
	#define PLS_CALIBRATE             0x51
	#define SEND_VOLTAGES_COMMAND     0x52
	#define SEND_CURRENTS_COMMAND     0x53
	#define SEND_POWERS_COMMAND       0x54
	#define VOLTAGES_DATA_RECEIVED    0x55
	#define CURRENTS_DATA_RECEIVED    0x56
	#define POWERS_DATA_RECEIVED      0x57
	#define VOLTAGES_CALIBRATED       0x58
	#define CURRENTS_CALIBRATED       0x59
	#define POWERS_CALIBRATED         0x5a
	
	extern unsigned char Self_Calib_State; 
#endif


#define DBUS			P9OUT

//#define EnLCD_SET 	 	(P10OUT |= BIT0)  //var
#define RWLCD_SET  	 	(P10OUT |= BIT1)  //DATA
#define RSLCD_SET 	 	(P10OUT |= BIT2)  //CLOCK

//#define EnLCD_RESET 	 (P10OUT &= ~BIT0)
#define RWLCD_RESET  	 (P10OUT &= ~BIT1) 
#define RSLCD_RESET 	 (P10OUT &= ~BIT2) 

#define Enable_BL()(P10OUT &= ~BIT0)
#define Disable_BL()(P10OUT |= BIT0)

/*
#define CGRNO 		5
#define SPACE		0x20

//-----------------------Stored in CGRAM OF LCD
#define ARROW  		0x01
#define DNARROW  	0x02	
#define UPARROW  	0x03
#define ENTER_SYM  	0x04
//-----------------------Stored in CGRAM OF LCD

#define BLINKLCD 	0x09
#define ONCURSOR 	0x0A
#define ONLCD 		0x0C
#define CLEARLCD   	0x01
#define HOMELCD 	0x02
#define SET_ADD0 	0x80
#define ENTRYMODE 	0x06
#define FUNCSET 	0x38

#define NONE		0
#define KILO 		1
#define MEGA 		2
#define GIGA 		3
#define MILI 		4
*/

//#define KEY1		(P4IN & 0x01)
//#define KEY2		(P4IN & 0x02)
//#define KEY3		(P4IN & 0x04)
//#define KEY4		(P4IN & 0x08)

#define KEY1		(P1IN & 0x02)
#define KEY2		(P1IN & 0x08)
#define KEY3		(P1IN & 0x10)
#define KEY4		(P1IN & 0x20)
/*#ifdef	FFT
	#define DEBOUNCE	2
#else
	#define DEBOUNCE	5
#endif*/
#define DEBOUNCE	   5

//#define set_total_energy_pulse_indicator()          (P5OUT &= ~BIT7)
//#define clr_total_energy_pulse_indicator()          (P5OUT |= BIT7)
#define set_total_energy_pulse_indicator()          (P2OUT &= ~BIT6)
#define clr_total_energy_pulse_indicator()          (P2OUT |= BIT6)

//#define NXT 	KEY4_check()
//#define PROG 	KEY1_check()
//#define DEC 	KEY3_check()
//#define INC 	KEY2_check()

#define UP		INC
#define DN		DEC

#define PHASE_3P4W	0
#define PHASE_3P3W	1

#define SCROLL_TIME 8
#define	FAV_RET_PAGE_TIME 120

#define ACTIVE_ENERGY	0
#define REACTIVE_ENERGY	1
#define APARENT_ENERGY	2

//#define FFT		 

#define PI			3.14159265359	
#define Delta_t		0.00024414
#define Delta_t_m100		0.024414
//#define Two_Omega_t	(2.0 * PI * Delta_t * 50.0)
//#define Two_Pi_t	(2.0 * PI * Delta_t)
#define Two_Pi_t 0.00153397686

//#define Power_K_Int_500ms	(1/7200000.0)  //killo 0.1kwh
#define Power_K_Int_500ms	(1/14400000.0)  //killo 0.1kwh

//#define I_Gain_4_devide	(1/3.87)
//#define V_Gain_4_devide	(1/3.86)
//#define V_Gain_2_devide	(1/1.966)


//#define TIME_INTEGRATION_1SEC	(1.0/(10000.0 * 1000.0))
//#define TIME_INTEGRATION_1SEC	0.000000100

#define TIME_OUT_1MIN	60 
/*
void Initlcd(void);    
void Wr_lcd_CGRAM(void);
void wrlcdcmd(unsigned char cmd);
void wr_lcd(char LineNo,char msg[]);
void wrlcddata(unsigned char Data); // We can also remove wrchar() and directly use 
void wrmsg(char LineNo,char stloc, char msg[]);
void filllcd(unsigned char start_loc,char end_loc,char stuff);
void LCD_Disp(void);
*/
void Run_Mode(void);
//void gain_set(void);
void derive_gainconst(void);

//void float2str(float value, char *data,unsigned char bytes);

void Password_Mode(void);
void Program_Mode(void);
void store_energy_pulses(void);
void On_hour_calculate(void);
void Hour_rst(void);
//unsigned char KEY1_check(void);
//unsigned char KEY2_check(void);
//unsigned char KEY3_check(void);
//unsigned char KEY4_check(void);

void decimal_to_array(unsigned int value, unsigned char length, unsigned char *array); 
unsigned int array_to_decimal(unsigned char *array, unsigned char length);
void long_to_array(unsigned long value, unsigned char length, unsigned char *array);

#endif
